<?php 
/**
* Extension of Codeigniter's {@link http://codeigniter.com/user_guide/helpers/html_helper.html html_helper}.
*
* @package direct-project-innovation-initiative
* @subpackage helpers
*/

load_libraries('Error_helper', 'Validator');

/**
* Takes an associative array of HTML attributes and returns the values as a string ready to be added to an HTML tag
*
* Example array: array('id' => 'display_name', 'class' => 'text-input numeric', 'required' => 'required').
*
* @param array
* @return string
*/
function attributes_to_string($attributes){
	if(is_string($attributes)) return $attributes;
	if(!validates_as('associative_array', $attributes)) return should_be('string or an associative array', $attributes);
	$markup = '';
	foreach ($attributes as $key => $value){
		if(is_array($value))
			$value = implode(' ', $value);
		
		$markup .= ' '.$key.'="'.$value.'"';
	}
	return $markup;
}

/**
* Merges two associative arrays of HTML attributes.
*
* Like {@link array_merge()}, but correctly merges classes. 
* Example array: array('id' => 'display_name', 'class' => 'text-input numeric', 'required' => 'required').
*
* @param array
* @param array
* @return array
*/
function merge_attributes($one, $two){
	if(!validates_as('associative_array', $one)) return should_be('associative_array', $one);
	if(!validates_as('associative_array', $two)) return should_be('associative_array', $two);
	
	if(!empty($one['class']) && !empty($two['class'])){
		$classes_for_one = explode(' ', $one['class']);
		$classes_for_two = explode(' ', $two['class']);
		$two['class'] = implode(' ', array_merge($classes_for_one, $classes_for_two));
	}

	return array_merge($one, $two);
}